///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define MaxSchedules 10

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

const int MDays[12] =
{
     31, // 01 - Jan - 00 //
     28, // 02 - Feb - 01 //
     31, // 03 - Mar - 02 //
     30, // 04 - Apr - 03 //
     31, // 05 - May - 04 //
     30, // 06 - Jun - 05 //
     31, // 07 - Jul - 06 //
     31, // 08 - Aug - 07 //
     30, // 09 - Sep - 08 //
     31, // 10 - Oct - 09 //
     30, // 11 - Nov - 10 //
     31  // 12 - Dec - 11 //
};

//-------------------------------------------

char *WeekDayName[7] = {
    "Sun",
    "Mon",
    "Tue",
    "Wed",
    "Thu",
    "Fri",
    "Sat"
};

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//-------------------------------------------

struct _BackupTime{
    char *Name;
    char *Filename;
    char *Description;

    char *SQLServer;
    char *Database;
    char *DBDriver;
    char *Username;
    char *Password;
    BOOL IsTrusted;

    BOOL WeekDays[7];

    DWORD BackupWindowTimeBegin;
    DWORD BackupWindowTimeEnd;
    DWORD StartOnceTime;
    DWORD NextRunTime; // Do not save to file... Calculate at startup.

    DWORD LastRunTime;
    DWORD LastRunDate;

    DWORD ScheduleID;

    WORD IncrementHour;
    WORD IncrementMinute;

    BOOL OnlyRunOnce;
    BOOL OnHold;
    BOOL Active;
    BOOL ScheduleSet;
}; _BackupTime *BT;

//-------------------------------------------

struct _BackupOptionsDialog{
    char *BackupName;
    char *BackupDescription;
    char *BackupFileName;
    BOOL Complete;
}; _BackupOptionsDialog BOD;

//-------------------------------------------

struct _RestoreWithMoveDialog{
    char NewDBName[256];
    char NewDBLoc[256];

    BOOL Complete;
}; _RestoreWithMoveDialog RWMD;

//-------------------------------------------

struct _SQLOptionsDialog{
    char *SQLServer;
    char *DataBase;
    char *DBDriver;
    char *UserName;
    char *Password;
    BOOL IsTrusted;

    BOOL Complete;
}; _SQLOptionsDialog SQLOD;

//-------------------------------------------

struct _ScheduleDialog{
    HWND ListView_hWnd;
    int EditItem;
    LV_COLUMN LVColumb;
    LV_ITEM  LVItem;
}; _ScheduleDialog SD;

//-------------------------------------------

struct _EditScheduleDialog{
    int EditItem;
}; _EditScheduleDialog ESD;

//-------------------------------------------

struct _JobImformationDialog{
    HWND Database_hWnd;
    HWND Dialog_hWnd;
}; _JobImformationDialog JID;

//-------------------------------------------

struct _SQLPasswordDialog{
    HWND Dialog_hWnd;
    BOOL Cancel;
}; _SQLPasswordDialog SPWD;

//-------------------------------------------

struct _ManualRestoreDialog{
    HWND DataBase_hWnd;
    HWND Driver_hWnd;
    HWND Server_hWnd;
    HWND UserID_hWnd;
    HWND UserPW_hWnd;
    HWND RestoreFile_hWnd;
}; _ManualRestoreDialog MRD;

//-------------------------------------------

int NumberOfSetSchedules = 0;
DWORD CurrentScheduleID  = 0;

//-------------------------------------------

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int GetWeekDay(void)
{
    SYSTEMTIME ST;
    GetLocalTime(&ST);
    return ST.wDayOfWeek;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int GetNextRunDay(int xItem)
{
    int LocalLoop = GetWeekDay(); // LocalLoop = today

    SYSTEMTIME ST;

    GetLocalTime(&ST);

    DWORD CurrentTime = TimeToLong(ST.wHour, ST.wMinute, ST.wSecond);

    // If we only run once per day and the run once time is passed. Increment one day past today.
    if(BT[xItem].OnlyRunOnce == TRUE)
    {
        if(CurrentTime >= BT[xItem].StartOnceTime)
            LocalLoop++;
    }

    // If we only more than once per day and the end window time is passed. Increment one day past today.
    if(BT[xItem].OnlyRunOnce == FALSE)
    {
        if(CurrentTime >= BT[xItem].BackupWindowTimeEnd)
            LocalLoop++;
    }

    // This loop will hang the application if no run days are checked
    while(TRUE)
    {
        if( BT[xItem].WeekDays[LocalLoop] == TRUE )
            return LocalLoop;

    	if(LocalLoop == 6)
            LocalLoop = -1;

        LocalLoop++;
    }

    return -1;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void GetNextOperation(int xItem, char *Return)
{
    SYSTEMTIME ST;

    GetSystemTime(&ST);

    char TimeTemp[64];

    int Hour, Minute, Second;

    if(BT[xItem].OnlyRunOnce == TRUE)
        LongToTime(BT[xItem].StartOnceTime, &Hour, &Minute, &Second); // StartOnceTime
    else LongToTime(BT[xItem].NextRunTime, &Hour, &Minute, &Second); // NextRunTime

    ST.wHour   = Hour;
    ST.wMinute = Minute;
    ST.wSecond = Second;

    GetTimeFormat(LOCALE_USER_DEFAULT, TIME_NOSECONDS, &ST, NULL, TimeTemp, 56);

    sprintf(Return, "%s - %s", WeekDayName[ GetNextRunDay(xItem) ], TimeTemp);

}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void LoadWeekDaysFromScheduleItemIntoDialog(HWND xDialog, int ThisItem)
{
    int MainLoop = 0;

    while(MainLoop < 7)
    {
        if(BT[ThisItem].WeekDays[MainLoop] == TRUE)
            CheckDlgButton(xDialog, 1000 + MainLoop, BST_CHECKED);
        else CheckDlgButton(xDialog, 1000 + MainLoop, BST_UNCHECKED);

        MainLoop++;
    }
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int NumberOfDaysChecked(int ThisItem)
{
    int MainLoop = 0;
    int Checked  = 0;

    while(MainLoop < 7)
    {
        if( BT[ThisItem].WeekDays[MainLoop] == TRUE)
            Checked++;

        MainLoop++;
    }

    return Checked;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL IsAtleastOneDayChecked(HWND xDialog)
{
    int MainLoop = 0;

    while(MainLoop < 7)
    {
        if( IsDlgButtonChecked(xDialog, 1000 + MainLoop) )
            return TRUE;

        MainLoop++;
    }

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL IsAtleastOneDaySelected(int xItem)
{
    int MainLoop = 0;

    while(MainLoop < 7)
    {
        if( BT[xItem].WeekDays[MainLoop] == TRUE )
            return TRUE;

        MainLoop++;
    }

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void LoadWeekDaysFromDialogIntoScheduleItem(HWND xDialog, int ThisItem)
{
    int MainLoop = 0;

    while(MainLoop < 7)
    {
        if( IsDlgButtonChecked(xDialog, 1000 + MainLoop) == TRUE)
            BT[ThisItem].WeekDays[MainLoop] = TRUE;
        else BT[ThisItem].WeekDays[MainLoop] = FALSE;

        MainLoop++;
    }
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void LoadScheduleIntoDialog(void)
{
    int LocalLoop = 0;

    //CalculateSchedules();

	while(LocalLoop < MaxSchedules)
	{
        if(BT[LocalLoop].ScheduleSet == TRUE)
        {
            char ID[16];
            sprintf(ID, "%d", BT[LocalLoop].ScheduleID);

            SD.LVItem.pszText  = ID;
            SD.LVItem.mask     = LVIF_TEXT;
            SD.LVItem.iSubItem = 0;
            ListView_InsertItem(SD.ListView_hWnd,&SD.LVItem);

            SD.LVItem.pszText  = BT[LocalLoop].Name;
            SD.LVItem.mask     = LVIF_TEXT;
            SD.LVItem.iSubItem = 1;
            ListView_SetItem(SD.ListView_hWnd,&SD.LVItem);

            SD.LVItem.pszText  = BT[LocalLoop].Description;
            SD.LVItem.mask     = LVIF_TEXT;
            SD.LVItem.iSubItem = 2;
            ListView_SetItem(SD.ListView_hWnd,&SD.LVItem);

            char NextOperation[256];
            GetNextOperation(LocalLoop, NextOperation);

            SD.LVItem.pszText  = NextOperation;
            SD.LVItem.mask     = LVIF_TEXT;
            SD.LVItem.iSubItem = 3;
            ListView_SetItem(SD.ListView_hWnd,&SD.LVItem);

            SD.LVItem.pszText  = BT[LocalLoop].Database;
            SD.LVItem.mask     = LVIF_TEXT;
            SD.LVItem.iSubItem = 4;
            ListView_SetItem(SD.ListView_hWnd,&SD.LVItem);

        	SD.LVItem.pszText  = BT[LocalLoop].Filename;
            SD.LVItem.mask     = LVIF_TEXT;
            SD.LVItem.iSubItem = 5;
            ListView_SetItem(SD.ListView_hWnd,&SD.LVItem);
        }

        LocalLoop++;
    }
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int ScheduleIDToPosition(DWORD ItemID)
{
    int LocalLoop = 0;
	while(LocalLoop < MaxSchedules)
	{
        if(BT[LocalLoop].ScheduleID == ItemID)
            return LocalLoop;

        LocalLoop++;
    }
    return -1;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void EndScheduleByID(DWORD ItemID)
{
    int LocalLoop = 0;
	while(LocalLoop < MaxSchedules)
	{
        if(BT[LocalLoop].ScheduleID == ItemID)
        {
            BT[LocalLoop].ScheduleSet = FALSE;
            break;
        }
        LocalLoop++;
    }
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void InitSchedule(void)
{
    int LocalLoop = 0;

    BT = (_BackupTime *) calloc( sizeof(_BackupTime), MaxSchedules);

    while(LocalLoop < MaxSchedules)
    {
        char *Name                  = NULL;
        char *Filename              = NULL;
        char *Description           = NULL;

        char *SQLServer             = NULL;
        char *Database              = NULL;
        char *DBDriver              = NULL;
        char *Username              = NULL;
        char *Password              = NULL;
        BOOL IsTrusted              = FALSE;

        DWORD BackupWindowTimeBegin = 0;
        DWORD BackupWindowTimeEnd   = 0;

        DWORD ScheduleID            = 0;

        WORD IncrementDay           = 0;
        WORD IncrementHour          = 0;
        WORD IncrementMinute        = 0;

        BOOL OnlyRunOnce            = FALSE;
        BOOL OnHold                 = FALSE;
        BOOL Active                 = FALSE;
        BOOL ScheduleSet            = FALSE;

        LocalLoop++;
    }

    NumberOfSetSchedules = 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int NextAvailSchedule(void)
{
    int LocalLoop = 0;

    while(LocalLoop < MaxSchedules)
    {
        if(BT[LocalLoop].ScheduleSet == FALSE)
            return LocalLoop;

        LocalLoop++;
    }

    return -1;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int IncrementTheTime(DWORD CurrentTime,  int xItem)
{
    // If the job only runs on one day per week and its now past the time window end.
    if(NumberOfDaysChecked(xItem) == 1 && CurrentTime > BT[xItem].BackupWindowTimeEnd)
    {
        // Set the NextRunTime to the BackupWindowTimeBegin
        BT[xItem].NextRunTime = BT[xItem].BackupWindowTimeBegin;
        return 0;
    }

    // If thje next run day is not today
    if(GetNextRunDay(xItem) != GetWeekDay())
    {
        // Set the NextRunTime to the BackupWindowTimeBegin
        BT[xItem].NextRunTime = BT[xItem].BackupWindowTimeBegin;
        return 0;
    }

    // If the CurrentTime is past the jobs NextRunTime
    while(BT[xItem].NextRunTime <= CurrentTime)
    {
        // Perform a full increment on the NextRunTime
        BT[xItem].NextRunTime = (BT[xItem].NextRunTime + ((BT[xItem].IncrementMinute * 60) + ((BT[xItem].IncrementHour * 60) * 60)));
    }

    return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void CalculateSchedules(void)
{
    SYSTEMTIME ST;

    GetLocalTime(&ST);

    DWORD CurrentTime = TimeToLong(ST.wHour, ST.wMinute, ST.wSecond);

    int LocalLoop = 0;
    while(LocalLoop < MaxSchedules)
    {
        // If the schedule is set and it runs multiple times per day
        if(BT[LocalLoop].ScheduleSet == TRUE && BT[LocalLoop].OnlyRunOnce == FALSE)
        {
            // Set the NextRunTime to the BackupWindowTimeBegin
            BT[LocalLoop].NextRunTime = BT[LocalLoop].BackupWindowTimeBegin;

            // Now increment the schedule
            IncrementTheTime(CurrentTime, LocalLoop);
        }

        LocalLoop++;
    }
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int CheckSchedule(void)
{
    SYSTEMTIME ST;

    int LocalLoop     = 0;
    DWORD CurrentDate = 0;
    DWORD CurrentTime = 0;

    if(CurrentlyRunning == TRUE)
        return -1;

    GetLocalTime(&ST);

    CurrentDate = DateToLong(ST.wYear, ST.wMonth,  ST.wDay);
    CurrentTime = TimeToLong(ST.wHour, ST.wMinute, ST.wSecond);

    while(LocalLoop < MaxSchedules)
    {
        if(BT[LocalLoop].ScheduleSet == TRUE && BT[LocalLoop].Active == TRUE)
        {
            if(BT[LocalLoop].WeekDays[ST.wDayOfWeek] == TRUE)
            {
               // If job only runs once on scheduled days
                if(BT[LocalLoop].OnlyRunOnce == TRUE)
                {
                    if(CurrentDate != BT[LocalLoop].LastRunDate)
                    {
                        if( CurrentTime >= BT[LocalLoop].StartOnceTime )
                        {
                            BT[LocalLoop].LastRunTime = CurrentTime;
                            BT[LocalLoop].LastRunDate = CurrentDate;
                            return LocalLoop;
                        }
                    }
                }

                // if job runs multiple times on scheduled days
                if(BT[LocalLoop].OnlyRunOnce == FALSE)
                {
                    /*
                        If the backup BackupWindowTimeEnd is 5:00 and we check the schdule at 5:00.01
                            then the backup will be skipped. Therfor were going to try to make the time
                            window 60 seconds longer. This should now be fixed. 5/30/2003 2:53:30 PM

                        This did not work. If the last job ran at 5:00 and the backup took less than one minute,
                        The job would run twice. Try one second instead. 6/3/2003 10:10:00 AM

                    */


                    // If we missed our last backup then increment the time
                    if( (CurrentTime >= (BT[LocalLoop].BackupWindowTimeEnd + 1)) && CurrentTime > BT[LocalLoop].NextRunTime)
                    {
                        IncrementTheTime(CurrentTime, LocalLoop);
                    }

                    /*
                        If the backup BackupWindowTimeEnd is 5:00 and we check the schdule at 5:00.01
                            then the backup will be skipped. Therfor were going to try to make the time
                            window 60 seconds longer. This should now be fixed. 5/30/2003 2:57:08 PM

                        This did not work. If the last job ran at 5:00 and the backup took less than one minute,
                        The job would run twice. Try one second instead. 6/3/2003 10:10:00 AM

                    */


                    if( (CurrentTime >= BT[LocalLoop].BackupWindowTimeBegin) && (CurrentTime <= (BT[LocalLoop].BackupWindowTimeEnd + 1)) )
                    {
                        if(CurrentTime >= BT[LocalLoop].NextRunTime)
                        {
                            IncrementTheTime(CurrentTime, LocalLoop);
                            BT[LocalLoop].LastRunTime = CurrentTime;
                            BT[LocalLoop].LastRunDate = CurrentDate;
                            return LocalLoop;
                        }
                    }
                }
                //-----------------------------------------------
            }
        }

        LocalLoop++;
    }

    return -1;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

